function init() {

    add('kubejs:white_crystal_core', [['zh_cn', ["§7在大灾变之后，新发现的珍贵能量水晶核心", "§7其中蕴含着 §a奇异 §7的§4能量"]]])
    add('kubejs:brain_core', [['zh_cn', ["§7从高级丧尸脑核中掉落下来的", "§7其中蕴含着某些 §a特殊 §7的§4物质"]]])
    add('kubejs:rotten_bottle', [['zh_cn', ["§7已经完全变质了", "§7这是人能喝的东西？？？"]]])
    add('kubejs:rotten_soup', [['zh_cn', ["§7已经完全变质了", "§7这是人能喝的东西？？？"]]])
    add('kubejs:yeast_culture_flask_fermentation', [['zh_cn', ["§7已经 §4成功 §7发酵", "§7可以使用了"]]])
    add('kubejs:yeast_culture_flask', [['zh_cn', ["§7还没成功发酵", "§7需要一段时间的放置才可以 §a发酵 §7完全"]]])
	add('scannable:scanner', [['zh_cn', ["§7一定范围内的扫描仪器", "§7通过电池充电需要 §4取出 §a扫描器模块"]]])
    add('kubejs:cigarette_case', [['zh_cn', ["§7在大灾变之前，香烟一直是人们所喜爱的", "§7可以拆开   §4请勿模仿，吸烟有害健康！"]]])
	add('kubejs:cigarette_an', [['zh_cn', ["§7点一根？", "§4请勿模仿，吸烟有害健康！"]]])
	add('kubejs:ginger_soup', [['zh_cn', ["§2大冬天的必备物资", "§7良好的御寒汤"]]])
	add('cold_sweat:icebox', [['zh_cn', ["§7可以给水袋(满的)降温/升温", "§7无法防止§a食物腐烂"]]])
	add('kubejs:green_fertilizer', [['zh_cn', ["§7上好的肥料，不可§c混用", "§7可以增加你的§a作物产量（翻倍）"]]])
	add('kubejs:red_fertilizer', [['zh_cn', ["§7上好的肥料，不可§c混用", "§7可以加速你的§4作物生长（翻倍）"]]])
	add('hardcore_torches:fire_starter', [['zh_cn', ["§7简易的打火器", "§7有一定概率 §4点燃 §7失败"]]])
	add('kubejs:vaccine_zombie', [['zh_cn', ["§7注射后不再会感染上§c丧尸病毒", "§7PDC耗费极大物力研制，属于§c战略级§f物品"]]])
    add('kubejs:fire_medal', [['zh_cn', ["§7《 §c勇气是人类最伟大的赞歌 §7》", "§7由 §3PDC 第一执政 §7授予给 §b神之影战 §7中英雄的 §4荣誉"]]])
    add('kubejs:end_medal', [['zh_cn', ["§7《 §c终末之诗 §7》", "§7由 §3PDC 第一执政 §7授予给 §d终末之战 §7中英雄的 §4荣誉"]]])
    add('kubejs:pdc_medal_1', [['zh_cn', ["§7《 §c原木 §7》", "§7由 §3PDC 指挥部 §7授予给 §a在抵御深渊中做出贡献的 §4英雄荣誉"]]])
    add('kubejs:pdc_medal_2', [['zh_cn', ["§7《 §c圆石 §7》", "§7由 §3PDC 指挥部 §7授予给 §a在抵御深渊中做出贡献的 §4英雄荣誉"]]])
    add('kubejs:pdc_medal_3', [['zh_cn', ["§7《 §c煤炭 §7》", "§7由 §3PDC 指挥部 §7授予给 §a在抵御深渊中做出贡献的 §4英雄荣誉"]]])
    add('kubejs:pdc_medal_4', [['zh_cn', ["§7《 §c铁锭 §7》", "§7由 §3PDC 指挥部 §7授予给 §a在抵御深渊中做出贡献的 §4英雄荣誉"]]])
    add('kubejs:pdc_medal_5', [['zh_cn', ["§7《 §c金锭 §7》", "§7由 §3PDC 指挥部 §7授予给 §a在抵御深渊中做出突出贡献的 §4英雄荣誉"]]])
    add('kubejs:pdc_medal_6', [['zh_cn', ["§7《 §c钻石 §7》", "§7由 §3PDC 指挥部 §7授予给 §a在抵御深渊中做出突出贡献的 §4英雄荣誉"]]])
    add('kubejs:pdc_medal_7', [['zh_cn', ["§7《 §c绿宝石 §7》", "§7由 §3PDC 指挥部 §7授予给 §a在抵御深渊中做出巨大贡献的 §4英雄荣誉"]]])
    add('kubejs:pdc_medal_8', [['zh_cn', ["§7《 §c下界合金 §7》", "§7由 §3PDC 指挥部 §7授予给 §a在抵御深渊中做出巨大贡献的 §4英雄荣誉"]]])
    add('untamedwilds:material_pearl', [['zh_cn', ["§7一种古老的有机宝石", "§7虽然在已经在大灾变后的时代了，但仍然有人热衷于追求这些，真是§4可悲..."]]])
    add('untamedwilds:material_giant_pearl', [['zh_cn', ["§7一种古老的有机宝石", "§7虽然在已经在大灾变后的时代了，但仍然有人热衷于追求这些，真是§4可悲..."]]])
    add('geolosys:prospectors_pick', [['zh_cn', ["§7PDC研制，地质探测器", "§a右键地面§7进行数据分析扫描"]]])
    add('kubejs:cure_syringe', [['zh_cn', ["§7丧尸病毒抑制器", "§7治疗史蒂夫感染的§c丧尸病毒"]]])
    add('aquamirae:painting_anglerfish', [['zh_cn', ["§7深海沉船的遗留之物", "§7也许有人还会想要它们？谁知道呢..."]]])
    add('aquamirae:painting_oxygelium', [['zh_cn', ["§7深海沉船的遗留之物", "§7也许有人还会想要它们？谁知道呢..."]]])
    add('aquamirae:painting_tortured_soul', [['zh_cn', ["§7深海沉船的遗留之物", "§7也许有人还会想要它们？谁知道呢..."]]])
    add('aquamirae:painting_aurora', [['zh_cn', ["§7深海沉船的遗留之物", "§7也许有人还会想要它们？谁知道呢..."]]])
    add('kubejs:grass_fiber', [['zh_cn', ["§7从植物中获取", "§a树叶、草等§7均有概率掉落"]]])
    add('kubejs:dirty_rag', [['zh_cn', ["§7布上布满了灰尘", "§7也许洗洗还能用？谁知道呢......"]]])
    add('kubejs:blood_rag', [['zh_cn', ["§7布上全是干的血液", "§7也许洗洗还能用？谁知道呢......"]]])
    add('alcocraft:hop_seeds', [['zh_cn', ["§7酿酒的必备之物", "§7或许可以试试种在方块下面？"]]])
    add('kubejs:kt_box', [['zh_cn', ["§7装有大量物资的空投箱", "§7放置后，右击§4打开"]]])
    add('airdrop_supply:airdrop_location_fixer', [['zh_cn', ["§7空投信号坐标识别", "§a右键§c获取§7当前坐标位置§b识别§7信号"]]])
    add('kubejs:frozen_tilapia', [['zh_cn', ["§7在特殊情况下，或许可以用来作为武器防身(杀死深渊生物？)", "§7不会真有深渊生物死在这种东西上吧"]]])
    add('kubejs:bandage', [['zh_cn', ["§7治愈§a受伤", "§7避免影响生命的恢复"]]])
    add('kubejs:bullet_heavy_pack', [['zh_cn', ["§7包装着大量的§a重型子弹", "§7可长按§c右键§7拆开"]]])
    add('kubejs:bullet_long', [['zh_cn', ["§7包装着大量的§a长型子弹", "§7可长按§c右键§7拆开"]]])
    add('kubejs:bullet_medium_pack', [['zh_cn', ["§7包装着大量的§a中型子弹", "§7可长按§c右键§7拆开"]]])
    add('kubejs:bullet_short_pack', [['zh_cn', ["§7包装着大量的§a短型子弹", "§7可长按§c右键§7拆开"]]])
    add('kubejs:bullet_small_pack', [['zh_cn', ["§7包装着大量的§a小型子弹", "§7可长按§c右键§7拆开"]]])
    add('kubejs:bullet_special_pack', [['zh_cn', ["§7包装着大量的§a特型子弹", "§7可长按§c右键§7拆开"]]])
    add('kubejs:shell_pack', [['zh_cn', ["§7包装着大量的§a霰弹", "§7可长按§c右键§7拆开"]]])
    add('cold_sweat:filled_waterskin', [['zh_cn', ["§7旅行物资", "§7不可以§b饮用§7，只能用来维持§c体温"]]])
    add('cold_sweat:waterskin', [['zh_cn', ["§7旅行物资", "§7不可以§b饮用§7，只能用来维持§c体温"]]])
    add('hardcore_torches:unlit_torch', [['zh_cn', ["§7还没点着的火把", "§7你可以手持§a右键§c营火/火把等§7点燃"]]])
    add('zombie_extreme:magnetic_card', [['zh_cn', ["§d§lPDC密钥", "§7由组织派发的§a个人身份认证§7，或许可以试试§c开启§7一些东西？"]]])

}



const util_tooltips = {
    'zh_cn': {
        "item.kubejs.tooltip.hold_shift_off": "§8按住 [§7Shift§8] 查看详细信息",
        "item.kubejs.tooltip.hold_shift_on": "§8按住 [§fShift§8] 查看详细信息",
        "item.kubejs.tooltip.when_worn": "§7装备时:",
        "item.kubejs.tooltip.when_used": "§7使用时:",
        "item.kubejs.tooltip.when_eaten": "§7食用时:",
    },
    'en_us': { 
        "item.kubejs.tooltip.hold_shift_off": "§8Hold [§7Shift§8] View Details",
        "item.kubejs.tooltip.hold_shift_on": "§8Hold [§fShift§8] View Details",
        "item.kubejs.tooltip.when_worn": "§7When Equipping:",
        "item.kubejs.tooltip.when_used": "§7When Use:",
        "item.kubejs.tooltip.when_eaten": "§7When eaten:",
    }
}

const hold_shift_off = "item.kubejs.tooltip.hold_shift_off";
const hold_shift_on = "item.kubejs.tooltip.hold_shift_on";
const when_worn = "item.kubejs.tooltip.when_worn";
const when_used = "item.kubejs.tooltip.when_used";
const when_eaten = "item.kubejs.tooltip.when_eaten";


// enum for different tooltip presets
/**
 * @enum
 */
const TooltipType = {
    Create: "create",
    WhenWorn: "worn",
    WhenEaten: "eaten",
    WhenUsed: "used"
}
/**  used for function below it to count and number entires
 * */
let indexCounter = 0

/** initializes a create-style tooltip
 * @param {Internal.Item} item
 * @param {string} tooltipEntry
 * @returns {[Number, Internal.Item, TooltipType, [[String, [String]]]]}
 */
function add(item, lang_entry_pair_array, type) {
    // null/undefined check for type
    type = type || TooltipType.Create;
    if (!itemHaveTooltipsSet.has(item))
        itemHaveTooltipsSet.add(item)
    const result = [indexCounter++, item, type, lang_entry_pair_array]
    tooltipList.push(result)
    // return is not necessary but I keep it in case I need it in future
    return result
}
/** list for all the tooltips
 * @type {[Number, Internal.Item, TooltipType, [[String, [String]]]]}
 */
let tooltipList = []

/** set of all items that have tooltips
 * @type {Set<Internal.Item>}
 */
let itemHaveTooltipsSet = new Set()

// shortcut function for index-langkey generator
let langKey = (i) => {
    return ('item.kubejs.tooltip.tooltip_' + i)
}

onEvent("client.generate_assets", event => {
    // call the init to generate all needed stuff
    init()

    /**using map to hold every locale's json separately
     * @type {Map<string, Object>}
     */ 
    let lang_jsonMap = new Map()

    // for every single accumulated array object, add the entry
    tooltipList.forEach(obj => {
        let i = obj[0]
        let item = obj[1]
        let tooltipType = obj[2]
        let arr = obj[3]
        arr.forEach(obj2 => {
            let lang = obj2[0]
            let tt_entry = obj2[1]
            if (Array.isArray(tt_entry)) {
                tt_entry = Array.from(tt_entry).join('\n')
            }
           
            // Tooltip entry modification according to type
            switch (tooltipType) {
                case TooltipType.Create: 
                    // parts inside {curly braces} are highlighted
                    tt_entry = '§4' + tt_entry.replace(/{/g, '§c').replace(/}/g, '§4').replace(/\n/g, '\n§4');
                    break;
                case TooltipType.WhenEaten:
                    // add "- " instead of "\n" (as in enumerating properties). Also highlight parts in {curly braces}
                    tt_entry = '§9- ' + tt_entry.replace(/{/g, '§a').replace(/}/g, '§9').replace(/\n/g, '\n§9- ');
                    break;
                case TooltipType.WhenUsed:
                    tt_entry = '§9- ' + tt_entry.replace(/{/g, '§a').replace(/}/g, '§9').replace(/\n/g, '\n§9- ');
                    break;
                case TooltipType.WhenWorn:
                    tt_entry = '§9- ' + tt_entry.replace(/{/g, '§a').replace(/}/g, '§9').replace(/\n/g, '\n§9- ');
                    break;
            }


            if (lang_jsonMap.has(lang)) {
                let jsonEntry =  lang_jsonMap.get(lang);
                jsonEntry[langKey(i)] = tt_entry
                lang_jsonMap.set(lang, jsonEntry)
            } else {
                let jsonEntry = util_tooltips[lang] || jsonEntry['en_us']
                jsonEntry[langKey(i)] = tt_entry;
                lang_jsonMap.set(lang,  jsonEntry)
            }
        })
    })
    lang_jsonMap.forEach((obj, locale) => {
        event.add("kubejs:lang/" + locale, obj)
    })
})

// Event that (I believe) runs when game wants to create a tooltip for an item (or maybe prepare all tooltips for all items?)
onEvent("item.tooltip", event => {
    /**@type {Set<Internal.Item>} */
    
    itemHaveTooltipsSet.forEach(item => {
        event.addAdvanced(item, (_1, _2, component) => {
            if (!event.shift) {
                component.add(Component.translate(hold_shift_off))
            } else {
                component.add(Component.translate(hold_shift_on))
            }
        })
    })
    tooltipList.forEach(obj => {
        let i = obj[0]
        let item = obj[1]
        let type = obj[2]
        event.addAdvanced(item, (_1, _2, component) => {
            if (!event.shift) {
            } else {
                switch (type) {
                    case (TooltipType.WhenEaten):
                        component.add(Component.translate(when_eaten))
                        break;
                    case (TooltipType.WhenUsed):
                        component.add(Component.translate(when_used))
                        break;
                    case (TooltipType.WhenWorn):
                        component.add(Component.translate(when_worn))
                        break;
                }
                Component.translate(langKey(i)).getString().split('\n').forEach(str => {
                    component.add(str)
                })
                
            }
        })
        
    })
})